unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  AHMTStoreData, AHMSystemClass, StdCtrls, AHMTFormManager;

type
  TForm1 = class(TForm)
    AHMFormManager1: TAHMFormManager;
    AHMStoreData1: TAHMStoreData;
    Edit1: TEdit;
    Button1: TButton;
    FontDialog1: TFontDialog;
    Button2: TButton;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  if FontDialog1.Execute then
  begin
    Edit1.Font:=FontDialog1.Font;
    with AHMStoreData1 do
    begin
      {Writing Boolean Values}
      WriteBool('FontStyleBold',fsBold in FontDialog1.Font.Style);
      WriteBool('FontStyleItalic',fsItalic in FontDialog1.Font.Style);
      WriteBool('FontStyleStrikeOut',fsStrikeout in FontDialog1.Font.Style);
      WriteBool('FontStyleUnderline',fsUnderline in FontDialog1.Font.Style);
      {Writing Integer Values}
      WriteInt('FontSize',FontDialog1.Font.Size);
      {Writing String Values}
      WriteStr('FontName',FontDialog1.Font.Name);
    end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  with AHMStoreData1 do
  begin
    DataStore.IniFile.IniFileName:=ExtractFilePath(Application.Exename)+'\MyIni.ini';
    {Reading Boolean Values}
    if ReadBool('FontStyleBold',fsBold in Edit1.Font.Style) then Edit1.Font.Style:=Edit1.Font.Style + [fsBold];
    if ReadBool('FontStyleItalic',fsItalic in Edit1.Font.Style) then Edit1.Font.Style:=Edit1.Font.Style + [fsItalic];
    if ReadBool('FontStyleStrikeOut',fsStrikeout in Edit1.Font.Style) then Edit1.Font.Style:=Edit1.Font.Style + [fsStrikeOut];
    if ReadBool('FontStyleUnderline',fsUnderline in Edit1.Font.Style)  then Edit1.Font.Style:=Edit1.Font.Style + [fsUnderline];
    {Reading Integer Values}
    Edit1.Font.Size:=ReadInt('FontSize',Edit1.Font.Size);
    {Reading String Values}
    Edit1.Font.Name:=ReadStr('FontName',Edit1.Font.Name);
    {Reading Encrypted Values}
    Edit1.Text:=AHMStoreData1.ReadCrypt('MyEditText',Edit1.Text);
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  {Writing Encrypted Values}
  AHMStoreData1.WriteCrypt('MyEditText',Edit1.Text);
end;


end.
